/*
 * Experiments.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef EXPERIMENTS_H_
#define EXPERIMENTS_H_

#include <StandardLibs.h>
#include <NetworkStructure.h>
#include <Imports.h>
#include <Exports.h>
#include <ContagionParameters.h>
#include <LikelihoodEstimators.h>
#include <ContagionModels.h>
#include <MPIparalelization.h>
#include <ContagionStatistics.h>
#include <IgraphVersionCompile.h>


void run_MPI_benchmark_experiment(int argc, char **argv);

void add_likelihoods_to_benchmark(int benchmark_phase, vector<likelihood_struct> * likelihood_array);

void add_sim_num_for_benchmark_convergence(vector<long int> * num_simulations_array_exp, int exponent_size_min, int exponent_size_max);

void MPI_benchmark_single_estimator_single_exp(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileBenchMarkPath);

void run_MPI_ranking_Temporal_Net_ran_sensors_experiment (int argc, char **argv);

void MPI_ranking_mask_sync_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath, int collector_write_res, double mask_bit_prob);

void copy_mask_to_statistics_struct(int * mask_list, int mask_list_size, statistics * statistic_parameters, infected_structure * p_infected_parameters);

void generate_mask(igraph_vector_t *mask, double mask_bit_prob);

void runMPI_detectability_experiment(int argc, char **argv);

void MPI_detectability_single_estimator(input *input_args, int mpi_rank, int mpi_size, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics * statistic_parameters, likelihood_struct * likelihood_tmp);

void get_synthetic_realization_test_net(vector<igraph_vector_t *> * realization_set);

void destroy_realization_set(vector<igraph_vector_t *> * realization_set);

void runMPI_detectability_synthetic_net_experiment(int argc, char **argv);

void MPI_detectability_single_estimator_synthetic_net(input *input_args, int mpi_rank, int mpi_size, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics * statistic_parameters, likelihood_struct * likelihood_tmp, int exp_id);

int get_rand_T_value_epsilon(double p_T_distr_param);

void add_sim_num_for_phase1(vector<long int> * num_simulations_array_exp, int exponent_size_min, int exponent_size_max);

int find_diameter_temporal_subgraph(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes);

int DFS_find_inf_neighbour(infected_structure * p_infected_parameters, igraph_vector_t *node_flags_dfs, igraph_vector_t * realization, igraph_vector_t * mask, int node_tmp);

void find_potential_candidates(infected_structure * p_infected_parameters, igraph_vector_t * realization, igraph_vector_t * mask, igraph_vector_t * realization_candidates);

int get_source_rank(double * likelihood, infected_structure * p_infected_parameters);

//void MPI_ranking_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp);
void MPI_ranking_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath);

void run_MPI_ranking_Temporal_Net_convergence_soft_a_range_experiment (int argc, char **argv);

void MPI_ranking_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath, int collector_write_res);

void dump_collector_results(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp);

void run_MPI_ranking_Temporal_Net_experiment (int argc, char **argv);

void run_MPI_ranking_static_net_experiment (int argc, char **argv);

void run_MPI_ranking_Avio_experiment (int argc, char **argv);

void run_MPI_pruning_speed_experiment(int argc, char **argv);

int getRandomNodeFromPeriod(infected_structure * p_infected_parameters, int T_rel_sample_start, int T_rel_sample_end, int *source_time);

void check_master_realization_acitvities(infected_structure * p_infected_parameters, vector<int> * node_activity_times, contagion_param_struct * epidemicParameters_exp,int node_target);

int find_ML_distance_to_source(double * likelihood, infected_structure * p_infected_parameters, int mpi_rank, int * ML_node_id);

void tranform_to_proability_distr(double * likelihood, infected_structure * p_infected_parameters);

void calculate_neighbourhood_prob(double * neighbourhood_prob, double * likelihood, infected_structure * p_infected_parameters);

void make_experiment_log(int mpi_rank, int exp_id, int master_generate_real, input *input_args, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp);

void validate_temporal_null_model(int mpi_rank, infected_structure * p_infected_structure_null, infected_structure * p_infected_structure_orig, int T_end);

void run_MPI_ranking_Temporal_Net_convergence_experiment (int argc, char **argv);

#endif /* EXPERIMENTS_H_ */
